<?php

namespace Drupal\schema_book\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'schema_book_name' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_book_name",
 *   label = @Translation("name"),
 *   description = @Translation("REQUIRED BY GOOGLE. The title of the book."),
 *   name = "name",
 *   group = "schema_book",
 *   weight = -1,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE
 * )
 */
class SchemaBookName extends SchemaNameBase {
  // Nothing here yet. Just a placeholder class for a plugin.
}
