<?php

namespace Drupal\schema_movie\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaPersonOrgBase;

/**
 * Provides a plugin for the 'schema_movie_actor' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_movie_actor",
 *   label = @Translation("actor"),
 *   description = @Translation("RECOMMENDED BY GOOGLE. The names of Actors."),
 *   name = "actor",
 *   group = "schema_movie",
 *   weight = 4,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = TRUE
 * )
 */
class SchemaMovieActor extends SchemaPersonOrgBase {

}
