<?php

namespace Drupal\schema_movie\Plugin\metatag\Tag;

use Drupal\schema_metatag\Plugin\metatag\Tag\SchemaNameBase;

/**
 * Provides a plugin for the 'seasonNumber' meta tag.
 *
 * - 'id' should be a globally unique id.
 * - 'name' should match the Schema.org element name.
 * - 'group' should match the id of the group that defines the Schema.org type.
 *
 * @MetatagTag(
 *   id = "schema_movie_season_number",
 *   label = @Translation("seasonNumber"),
 *   description = @Translation("REQUIRED BY GOOGLE for TVSeason."),
 *   name = "seasonNumber",
 *   group = "schema_movie",
 *   weight = 3,
 *   type = "string",
 *   secure = FALSE,
 *   multiple = FALSE
 * )
 */
class SchemaMovieSeasonNumber extends SchemaNameBase {


}
