/**
 * @file
 * JavaScript behaviors for Webform UI.
 */

(function ($, Drupal, drupalSettings) {

  'use strict';

  /**
   * Remove .button-primary class from .action-links .button-secondary.
   *
   * The seven.theme adds the .button-primary class to all actions.
   *
   * @type {Drupal~behavior}
   *
   * @see webform_ui_preprocess_menu_local_action()
   * @see seven_preprocess_menu_local_action()
   * @see webform_ui.module.css
   */
  Drupal.behaviors.webformUiElementsActionsSecondary = {
    attach: function (context, settings) {
      $(context).find('.action-links .button--secondary').once('webform-ui-elements-webform-actions-secondary').each(function () {
        $(this).removeClass('button--primary');
      });
    }
  };

  /**
   * Adds keyboard support to the form builder.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.webformUiElementsKeyboard = {
    attach: function (context, settings) {
      var $table = $(context)
        .find('.webform-ui-elements-table')
        .once('webform-ui-elements-keyboard');

      // Disable autosubmit when Enter is pressed on 'Required' checkboxes.
      $table.find('td input:checkbox')
        .on('keyup keypress', function (e) {
          if (e.which === 13) {
            e.preventDefault();
            return false;
          }
        });

      // Move keyboard focus up (38) or down (40).
      $table.find('td:first-child a:not(.tabledrag-handle), td input:checkbox, td .webform-dropbutton li.dropbutton-action a, td .webform-dropbutton button')
        .on('keydown', function (event) {
          if (event.which === 38 || event.which === 40) {
            var $cell = $(this).closest('td');
            var $row = $cell.parent();
            var direction = (event.which === 38) ? 'prev' : 'next';
            var index = $cell.index();
            var tagName = this.tagName;
            while ($row[direction]().length) {
              $row = $row[direction]();
              $cell = $row.find('td').eq(index).find(tagName);
              if ($cell.length) {
                $cell.focus();
                break;
              }
            }
            event.preventDefault();
          }
        });

      // Move keyboard focus left (37) or right (39).
      $table.find('td a:not(.tabledrag-handle), td input, td select, td button')
        .on('keydown', function (event) {
          if (event.which === 37 || event.which === 39) {
            var $cell = $(this).closest('td');
            var direction = (event.which === 37) ? 'prev' : 'next';
            var $focus;


            // Move keyboard focus within operations dropbutton.
            if ($(this).closest('.webform-dropbutton').length) {
              if (direction === 'next' &&
                this.tagName === 'A' &&
                $(this).parent('.dropbutton-action').length) {
                $cell.find('button').focus();
                event.preventDefault();
                return;
              }
              else if (direction === 'prev' && this.tagName === 'BUTTON') {
                $cell.find('a').focus();
                event.preventDefault();
                return;
              }
            }

            while ($cell.length) {
              $cell = $cell[direction]();
              $focus = $cell.find('a:visible, input:visible, select:visible');
              if ($focus.length) {
                $focus.focus();
                event.preventDefault();
                return;
              }
            }
          }

        });

    }
  };

})(jQuery, Drupal, drupalSettings);
